VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsWinamp"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

' API Declares

Private Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function PostMessage Lib "user32" Alias "PostMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function GetWindowTextLength Lib "user32" Alias "GetWindowTextLengthA" (ByVal hwnd As Long) As Long
Private Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hwnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
Private Declare Function FindWindowEx Lib "user32" Alias "FindWindowExA" (ByVal hWnd1 As Long, ByVal hWnd2 As Long, ByVal lpsz1 As String, ByVal lpsz2 As String) As Long
Private Declare Function SendMessageByString Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String) As Long
Private Declare Function SendMessageLong Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

' Constants

Private Const WM_WA_IPC         As Long = &H400 ' WM_USER is never needed so eh?
Private Const WM_COMMAND        As Long = &H111 ' Used for setting playback mode (pause,play,etc).

Private Const IPC_ISPLAYING     As Long = 104   ' Used for checking if winAMP is playing/paused/stopped
Private Const IPC_GETOUTPUTTIME As Long = 105   ' Used in getting song position/length.
Private Const IPC_SETVOLUME     As Long = 122   ' Used with setting volume.
Private Const IPC_GETINFO       As Long = 126   ' Used in retrieving bitrate.

Public Enum PlayType
    optPreviousSong = 40044 ' Button1
    optPlaySong = 40045     ' Button2
    optPauseSong = 40046    ' Button3
    optStopSong = 40047     ' Button4
    optNextSong = 40048     ' Button5
    optFadeToStop = 40147   ' Button4_Shift ? :/
End Enum

Public Enum Enum_WA_Command
  WA_Previous_track = 40044
  WA_Next_track = 40048
  WA_PLAY = 40045
  WA_Pause_Unpause = 40046
  WA_STOP = 40047
  WA_Fadeout_and_stop = 40147
  WA_Stop_after_current = 40157
  WA_Fast_forward_5_seconds = 40148
  WA_Fast_rewind_5_seconds = 40144
  WA_Start_of_playlist = 40154
  WA_Go_to_end_of_playlist = 40158
  WA_Open_file_dialog = 40029
  WA_Open_URL_dialog = 40155
  WA_Open_file_info_box = 40188
  WA_Set_time_display_mode_to_elapsed = 40037
  WA_Set_time_display_mode_to_remaining = 40038
  WA_Toggle_preferences_screen = 40012
  WA_Open_visualization_options = 40190
  WA_Open_visualization_plug_in_options = 40191
  WA_Execute_current_visualization_plug_in = 40192
  WA_Toggle_about_box = 40041
  WA_Toggle_title_Autoscrolling = 40189
  WA_Toggle_always_on_top = 40019
  WA_Toggle_Windowshade = 40064
  WA_Toggle_Playlist_Windowshade = 40266
  WA_Toggle_doublesize_mode = 40165
  WA_Toggle_EQ = 40036
  WA_Toggle_playlist_editor = 40040
  WA_Toggle_main_window_visible = 40258
  WA_Toggle_minibrowser = 40298
  WA_Toggle_easymove = 40186
  WA_Raise_volume_by_1 = 40058
  WA_Lower_volume_by_1 = 40059
  WA_Toggle_repeat = 40022
  WA_Toggle_shuffle = 40023
  WA_Open_jump_to_time_dialog = 40193
  WA_Open_jump_to_file_dialog = 40194
  WA_Open_skin_selector = 40219
  WA_Configure_current_visualization_plug_in = 40221
  WA_Reload_the_current_skin = 40291
  WA_Close_Winamp = 40001
  WA_Moves_back_10_tracks_in_playlist = 40197
  WA_Show_the_edit_bookmarks = 40320
  WA_Adds_current_track_as_a_bookmark = 40321
  WA_Play_audio_CD = 40323
  WA_Load_a_preset_from_EQ = 40253
  WA_Save_a_preset_to_EQF = 40254
  WA_Opens_load_presets_dialog = 40172
  WA_Opens_auto_load_resets_dialog = 40173
  WA_Load_default_preset = 40174
  WA_Opens_save_preset_dialog = 40175
  WA_Opens_auto_load_save_preset = 40176
  WA_Opens_delete_preset_dialog = 40178
  WA_Opens_delete_an_auto_load_preset_dialog = 40180
End Enum

Private hwnd As Long ' Stores winAMP's hWnd, god what a shitty name :P

Public Function FindWinAMP() As Boolean
'
' Name    : FindWinAMP()
' Purpose : Returns true if the window is found (hWnd_WinAMP is set), false otherwise.
' Notes   : Called on Class_Initialize()
'
    hwnd = FindWindow("Winamp v1.x", vbNullString)
    FindWinAMP = hwnd
End Function

Public Function PlaybackStatus() As Byte
'
' Name    : PlaybackStatus()
' Purpose : Returns playback status in the form of a byte.
' Notes   : Returns 0 if stopped, 1 if playing, or 3 if paused.
'
    PlaybackStatus = SendMessage(hwnd, WM_WA_IPC, 0, IPC_ISPLAYING)
End Function

Public Function GetWinampSongTitle(ByVal NumberIncluded As Boolean) As String
'
' Name    : GetWinampSongTitle(bool NumberIncluded)
' Purpose : Retrieves the title of the currently playing song.
' Notes   : Shitty way of doing it but oh well :(
'
On Error GoTo errGetWinampSongTitleError

    Dim WindowTitle As String
    WindowTitle = String(GetWindowTextLength(hwnd) + 1, vbNullChar) ' Allocate memory!
    
    Call GetWindowText(hwnd, WindowTitle, Len(WindowTitle))
    WindowTitle = Mid$(WindowTitle, 1, Len(WindowTitle) - 10) ' Removes [Winamp] and the terminating null character
    
    WindowTitle = Replace(WindowTitle, " - Winamp", vbNullString)
    WindowTitle = Replace(WindowTitle, " [Stopped]", vbNullString)
    If NumberIncluded = True Then
        GetWinampSongTitle = WindowTitle
        Exit Function
    Else
        GetWinampSongTitle = Mid$(WindowTitle, InStr(1, WindowTitle, Chr(32)) + 1)
        Exit Function
    End If
errGetWinampSongTitleError:
    Call MsgBox(Err.Description, vbExclamation, "clsAdvancedWinAMP Error!")
End Function

Public Function GetCurrentSongPosition() As String
'
' Name    : GetCurrentSongPosition()
' Purpose : Retrieves the current song position in the format of MM:SS
' Notes   : The SendMessage retrieves current song position in milliseconds
'
On Error GoTo errGetCurrentSongPositionError
    Dim intMinutes As Integer
    Dim intSeconds As Integer
    Dim songPosition As Double
    songPosition = SendMessage(hwnd, WM_WA_IPC, 0, IPC_GETOUTPUTTIME)
    songPosition = Int(songPosition)
    intMinutes = songPosition / 60000
    intSeconds = (songPosition / 1000& Mod 60&)
    GetCurrentSongPosition = Format$(intMinutes, "00:") & Format$(intSeconds, "00")
    Exit Function
    
errGetCurrentSongPositionError:
    Call MsgBox(Err.Description, vbExclamation, "clsAdvancedWinAMP Error!")
End Function

Public Function GetCurrentSongLength() As String
'
' Name    : GetCurrentSongLength()
' Purpose : Retrieves the songs length in format of MM:SS
' Notes   : The SendMessage here retrieves current song length in seconds (Thank God)
'
On Error GoTo errCurrentSongLengthError
    Dim intMinutes As Integer
    Dim intSeconds As Integer
    Dim songLength As Double

    songLength = SendMessage(hwnd, WM_WA_IPC, 1, IPC_GETOUTPUTTIME)
    songLength = Int(songLength)
    intMinutes = songLength \ 60
    intSeconds = songLength - (intMinutes * 60) ' X = 300 - (2 * 60)
    GetCurrentSongLength = Format$(intMinutes, "00:") & Format$(intSeconds, "00")
    Exit Function
errCurrentSongLengthError:
    Call MsgBox(Err.Description, vbExclamation, "clsAdvancedWinAMP Error!")
End Function

Public Sub SetVolume(ByVal intVolume As Integer)
'
' Name:   : SetVolume(int intVolume)
' Purpose : Sets the WinAMP's windows' volume
' Notes   : Must be between 0 and 255
'
    Call SendMessage(hwnd, WM_WA_IPC, intVolume, IPC_SETVOLUME)
End Sub

Public Function GetSamplerate() As Long
'
' Name    : GetSamplerate()
' Purpose : Retrieves the samplerate (##khz)
' Notes   : None
'
    GetSamplerate = SendMessage(hwnd, WM_WA_IPC, 0, IPC_GETINFO)
End Function


Public Function GetBitrate() As Long
'
' Name    : GetBitrate()
' Purpose : Retrieves the bitrate (###kbps)
' Notes   : None
'
    GetBitrate = SendMessage(hwnd, WM_WA_IPC, 1, IPC_GETINFO)
End Function

Public Function GetChannels() As String
'
' Name    : GetChannels()
' Purpose : Retrieves the channel-type.
' Notes   : Blah!
'
    Dim intChannels As Long
    intChannels = SendMessage(hwnd, WM_WA_IPC, 2, IPC_GETINFO)
    Select Case intChannels
        Case Is <= 0 ' No channels, owned.
            GetChannels = "No channels"
            Exit Function
        Case 1 ' Mono
            GetChannels = "Mono"
            Exit Function
        Case 2 ' Stereo
            GetChannels = "Stereo"
            Exit Function
        Case Is > 2 ' Surround sound B)
            GetChannels = "Surround Sound"
            Exit Function
        Case Else
            GetChannels = "UNKNOWN WTF?"
            Exit Function
    End Select
End Function

Public Function SetPlaybackMode(opt As PlayType)
'
' Name    : SetPlaybackMode(opt)
' Purpose : Sets playback mode (pause, stop, etc)
' Notes   : My idea for the enum ;)
'
    Call SendMessage(hwnd, WM_COMMAND, opt, 0)
End Function

Public Sub Execute(ByVal l_Command As Enum_WA_Command)
  SendMessage FindWindow("Winamp v1.x", vbNullString), &H111, l_Command, 0
End Sub

Private Sub Class_Initialize()
'
' Name    : Class_Initialize()
' Purpose : Called when an instance of the class is made
' Notes   : None
'
    If FindWinAMP() = False Then ' Uh oh
        MsgBox "Error with finding Winamp!", vbInformation, "><"
    End If
End Sub

